TITLE   'Electrical Conduction in Cone'                              { exa101.pde }
SELECT     errlim=3e-5     ngrid=1     spectral_colors
COORDINATES   ycylinder( 'r', 'z')			{ Student Edition }
VARIABLES   U
DEFINITIONS
   r0=2e-3     r1=10e-3     h=10e-3     cond=1.0e-3   	{ Silicon }
   Er=-dr(U)     Ez=-dz(U)     E=vector( Er, Ez)     Em=magnitude(E)
   Jr=cond*Er     Jz=cond*Ez     J=vector( Jr, Jz)     Jm=magnitude(J)
EQUATIONS
   (1/r)*dr( r*Jr)+ dz( Jz)=0   					{ div(J)=0 }
BOUNDARIES
region 'silicon'  start 'outer' (0,0)
   value(U)=0.0 line to (r0,0)
   natural(U)=0.0   line to (r1,h)
   value(U)=1.0 line to (0,h) natural(U)=0   line to close
feature
   start 'line' (r1/2, h) line to (0,0)
PLOTS
   contour( U)     surface( U)     contour( Em) log     vector( J) norm
   elevation( Jz) surf_integrate from (0,0) to (r0,0)	{ ? Current }
   elevation( Jz) surf_integrate from (0,h) to (r1,h)	{ ? Current }
   contour( Jm*Em) painted vol_integrate		{ ? Dissipation }
   elevation( tangential( E)) line_integrate on 'line'	{ ? Voltage }
END


